<div class="tab-pane fade" id="navs-top-document" role="tabpanel">
    <div class=" py-3 d-flex justify-content-between align-items-center">
        <div>
            <div class="h4 pb-0 mb-0">Required Documents</div>
            <small>Required Documents</small>
        </div>
        @if(in_array('Registration Setting Maintain',Session::get('permissions')))
        <button class="btn btn-primary bt-lg" data-bs-toggle="modal" data-bs-target="#AddDocuments"><span class="mdi mdi-plus"></span>Add</button>
        @endif
    </div>
    <table class="table border-top  table-no-bottom-border">
        <tbody class="table-border-bottom required_documents">

        </tbody>
    </table>
</div>

<div class="modal fade" id="delete_doc" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content">
        <div class="modal-header bg-danger px-4 py-2">
          <h5 class="modal-title text-white" id="deletedocLabel">Delete</h5>
      </div>
     
      <div class="modal-body">
        Are you sure you want to delete this record?<br><br>
        <b class="text-warning">Warning:</b>This record will no longer be available. Please ensure you
        genuinely want to delete it before clicking the delete button.
    </div>
    <div class="modal-footer border-top py-2">
      <button type="button" class="btn btn-outline-dark" data-bs-dismiss="modal">Close</button>
      <button type="button" class="btn btn-danger " id="delete-doc-info-id" data-id=""
          onclick="_delete_doc_delete(this)">Delete</button>
  </div>
    </div>
  </div>
</div>

<div class="modal fade" id="AddDocuments" tabindex="-1" aria-labelledby="AddDocuments" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header bg-primary px-4 py-2">
                <h5 class="modal-title text-white" id="AddDocumentsLabel">Documents</h5>
            </div>
            <div class="modal-body">
                <div class="mb-2">
                    <label for="defaultFormControlInput" class="form-label">Title</label>
                    <input type="text" class="form-control" id="required-document-title"
                        placeholder="Documents" aria-describedby="defaultFormControlHelp">
                </div>
                <input type="hidden" class="form-control height-width" id="edit-doc-info-id" value=""
                    aria-describedby="defaultFormControlHelp">
            </div>
            <div class="modal-footer border-top py-2">
                <button type="button" class="btn btn-outline-dark" data-bs-dismiss="modal">Close</button>
                <button type="button" class="btn btn-primary" onclick="_doc_info_store();">Save</button>
            </div>
        </div>
    </div>
</div>

    <div class="modal fade" id="EditdocInformation" tabindex="-1" aria-labelledby="EditdocInformationLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
      <div class="modal-content">
          <div class="modal-header bg-primary px-4 py-2">
              <h5 class="modal-title text-white" id="EditRoleLabel">Edit Documents</h5>
          </div>
          <div class="modal-body">
              <div class="mb-2">
                  <label for="defaultFormControlInput" class="form-label">Title</label>
                  <input type="text" class="form-control" id="edit-doc-info-title" placeholder="Document"
                      aria-describedby="defaultFormControlHelp">
              </div>
            </div> 
              <div class="modal-footer border-top py-2">
                  <button type="button" class="btn btn-outline-dark" data-bs-dismiss="modal">Close</button>
                  <button type="button" class="btn btn-primary" data-id=""
                      onclick="_doc_information_update();">Save Changes</button>
              </div>
          
      </div>
    </div>



    <div class="modal fade" id="DeleteDocument_information">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header bg-danger px-4 py-2">
                    <h5 class="modal-title text-white" id="deletedocLabel">Delete</h5>
                </div>
                <div class="modal-body">
                    Are you sure you want to delete this record?<br><br>
                    <b class="text-warning">Warning:</b>This record will no longer be available. Please ensure you
                    genuinely want to delete it before clicking the delete button.
                </div>
                <div class="modal-footer border-top py-2">
                    <button type="button" class="btn btn-outline-dark" data-bs-dismiss="modal">Close</button>
                    <button type="button" class="btn btn-danger " id="delete-doc-info-id" data-id=""
                        onclick="_delete_doc_delete(this)">Delete</button>
                </div>
            </div>
        </div>
    </div>
    <script>
        function _doc_info_store()
        {
            loader(true);

            var _FormData = new FormData();
            _FormData.append("title", $('#required-document-title').val());


            $.ajax({
                type: "POST",
                url: "{{ url('/required-document') }}",
                headers: {
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                },
                data: _FormData,
                processData: false,
                contentType: false,
                success: function(response) {
                    toastr.success(response.message);
                    _required_documents(response.data.required_documents);
                    $('#AddDocuments').modal('hide');
                    $('#required-document-information').val('');
                    loader(false);

                },
                error: function(response) {
                    loader(false);
                    if (response.status == 422) {
                        var errors = response.responseJSON.data;
                        $.each(errors, function(field, messages) {
                            error_msg = messages[0];
                            toastr.error(error_msg);
                        });
                    } else if (response.status == 500) {
                        toastr.error("Something went wrong")
                    } else {
                        toastr.error(response.responseJSON.message)
                    }
                }
            });

        }


        $(document).ready(function() {
            _required_documents_get();
        });

        function _required_documents_get()
        {
            // loader(true);              

            $.ajax({
                type: "GET",
                url: "{{ url('/required-document') }}",
                headers: {
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                },
                success: function(response) {
                    _required_documents(response.data.required_documents);
                    loader(false);
                },
                error: function(response) {
                    loader(false);
                    if (response.status == 422) {
                        var errors = response.responseJSON.data;
                        $.each(errors, function(field, messages) {
                            error_msg = messages[0];
                            toastr.error(error_msg);
                        });
                    } else if (response.status == 500) {
                        toastr.error("Something went wrong")
                    } else {
                        toastr.error(response.responseJSON.message)
                    }
                }
            });

        }

        function _required_documents(data)
        {
            var html = ``;
            for (var i = 0; i < data.length; i++) {
                html += `<tr>
                    <td>
                        <span class="fw-medium">${data[i].title}</span>
                    </td>
                    <td>
                    <input onchange="update_get_types(this);" type="checkbox" ${data[i].identity_text == 1 ?  'checked' : '' } @if(!in_array('Registration Setting Maintain',Session::get('permissions'))) disabled  @endif class="identity_text"  value="${data[i].id}" > Required Number
                    </td>
                    <td>
                    <input onchange="update_get_types(this);" type="checkbox" ${data[i].identity_file == 1 ?  'checked' : '' } @if(!in_array('Registration Setting Maintain',Session::get('permissions'))) disabled  @endif  class="identity_file"  value="${data[i].id}" > Required File
                    </td>
                    <td style="width: 130px;">
                    @if(in_array('Registration Setting Maintain',Session::get('permissions')))
                      <div class="dropdown cursor-pointer d-flex justify-content-center">
                      <div   id="dropdownMenuButton1" data-bs-toggle="dropdown" aria-expanded="false"><span class="mdi mdi-dots-vertical list_color"></span></div>

                      <ul class="dropdown-menu" aria-labelledby="dropdownMenuButton1">
                      <li><a class="dropdown-item py-1 ps-2" data-title="${data[i].title}" data-id="${data[i].id}" onclick="_document_info_edit(this)"><span class="mdi mdi-square-edit-outline mdi-20px text-warning"></span> Edit</a></li>
                      <li><a class="dropdown-item py-1 ps-2" data-id="${data[i].id}" onclick="_doc_info_delete_modal(this)"><span class="mdi mdi-trash-can-outline mdi-20px text-danger"></span> Delete</a></li>
                      </ul>
                      </div>
                      @endif
                    </td>
                </tr>
                `;
            }

            if (html == ``) {
                html = `<div class="w-100 text-center mt-5"> 
                    No required documents yet
                    </div>`;
            }


            $('.required_documents').html(html);
        }

        function _document_info_edit(_this)
        {
            var id = $(_this).attr('data-id');
            var title = $(_this).attr('data-title');

            $('#edit-doc-info-id').val(id);
            $('#edit-doc-info-title').val(title);
            $('#EditdocInformation').modal('show');
        }

        function _doc_information_update()
        {
              loader(true);

            var id  =  $('#edit-doc-info-id').val();
            var information = $('#edit-doc-info-title').val();
              $.ajax({
                          type: "PUT",
                          headers: {
                              'X-CSRF-TOKEN': '{{ csrf_token() }}'
                          },
                          url : `/required-document/${id}?title=${information}`,
                          success: function(response) {
                            toastr.success(response.message);
                            _required_documents(response.data.required_documents);
                              $('#EditdocInformation').modal('hide');

                              loader(false);
                          },
                          error: function(response) {
                            loader(false);
                            if (response.status == 422) {
                            var errors = response.responseJSON.data;                    
                            $.each(errors, function(field, messages) {
                                  error_msg = messages[0]; 
                                  toastr.error(error_msg);
                            });
                            }
                    else  if (response.status == 500) {
                        toastr.error("Something went wrong")
                      }
                      else
                      {
                        toastr.error(response.responseJSON.message)
                      }
                        }
              });

        } 
      

        function _doc_info_delete_modal(_this)
        {
            var id = $(_this).attr('data-id');
            $('#delete-doc-info-id').attr('data-id', id);
            $('#delete_doc').modal('show');
        }

        function _delete_doc_delete(_this)
        {
            var id = $(_this).attr('data-id');

            $.ajax({
                headers: {
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                },
                type: "DELETE",
                url: "{{ url('/required-document') }}/" + id,
                success: function(response) {
                    toastr.success(response.message);
                    _required_documents(response.data.required_documents);
                    $('#delete_doc').modal('hide');

                    loader(false);
                },
                error: function(response) {
                    loader(false);
                    if (response.status == 422) {
                        var errors = response.responseJSON.data;
                        $.each(errors, function(field, messages) {
                            error_msg = messages[0];
                            toastr.error(error_msg);
                        });
                    } else if (response.status == 500) {
                        toastr.error("Something went wrong")
                    } else {
                        toastr.error(response.responseJSON.message)
                    }
                }
            });

        }

        function update_get_types(_this)
        {
                $.ajax({
                headers: {
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                },
                type: "POST",
                url: "{{ url('/update-get-types') }}/" + $(_this).attr('value'),
                data: {                    
                    'id' : $(_this).attr('value'),
                    'name' : $(_this).attr('class'),
                    'checked' : $(_this).is(":checked") ?  '1' : '0'
                },
                success: function(response) {
                    toastr.success('Changes Updated');
                    
                },
                error: function(response) {
                   
                    if (response.status == 500) {
                        toastr.error("Something went wrong")
                    } 
                }
            });
        }
    </script>
